package com.ejie.ab04b.util;

/**
 * @author GFI-NORTE
 * 
 */
public enum PlateaGenericEnum {

	ADREESSEE, AUTHORIZEDPERSONDATA, CHANNEL, CHANNELINFO, CONTACT, CONTACTS, DEPARTMENTNAME, DESCRIPTION, DESCRIPTOR, DESCRIPTORS, DOCUMENT, DOCUMENTS, ENTITYNAME, FAMILYNAME, LANGUAGE, MANAGINGUNITNAME, NOTICE, NOTICES, NOTIFICATION, PERSON, PERSONS, POSTALADDRESS, PROCEDURENAME, PROVINCIA, ROLENAME, SIGNATURE, SIGNATURES, VALUE;

	/**
	 * Dado un String, devuelve true si uno de los valores del enumerado es
	 * representado por ese String.
	 * 
	 *  valor            String
	 *  boolean
	 *
	 * @param valor the valor
	 * @return true, if successful
	 */
	public static boolean contieneValor(String valor) {
		boolean contiene = false;

		for (PlateaGenericEnum e : PlateaGenericEnum.values()) {
			// Comparamos con IgnoreCase porque los nombres de los campos no
			// están en mayúsculas. Por ejemplo procedureName, entityName, etc.
			if (e.toString().equalsIgnoreCase(valor)) {
				contiene = true;
				break;
			}
		}

		return contiene;
	}
}
